/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_bows_and_arrows.core.item;

import common.com.cursee.more_bows_and_arrows.core.tier.BowTier;
import common.com.cursee.more_bows_and_arrows.core.util.CommonEffectsUtil;
import common.com.cursee.more_bows_and_arrows.core.util.PaperEffectsUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.BlockHitResult;

public class TieredBowItem
extends BowItem {
    public final BowTier tier;

    public TieredBowItem(BowTier tier) {
        super(new Item.Properties().durability(tier.defaultDurability()));
        this.tier = tier;
    }

    public int getUseDuration(ItemStack $$0, LivingEntity $$1) {
        Item item = $$0.getItem();
        if (item instanceof TieredBowItem) {
            TieredBowItem tieredBowItem = (TieredBowItem)item;
            if (tieredBowItem.tier == BowTier.NETHERITE) {
                return 36000;
            }
        }
        return super.getUseDuration($$0, $$1);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext $$1, List<Component> components, TooltipFlag $$3) {
        if (!(itemStack.getItem() instanceof TieredBowItem)) {
            return;
        }
        BowTier instanceTier = this.tier;
        if (instanceTier == BowTier.BAMBOO) {
            instanceTier = BowTier.WOOD;
        }
        if (instanceTier == BowTier.STRIPPED_BAMBOO) {
            instanceTier = BowTier.STRIPPED_WOOD;
        }
        components.add((Component)Component.translatable((String)("lore.more_bows_and_arrows." + instanceTier.toString().toLowerCase() + "_bow1")));
        components.add((Component)Component.translatable((String)("lore.more_bows_and_arrows." + instanceTier.toString().toLowerCase() + "_bow2")));
        components.add((Component)Component.translatable((String)("lore.more_bows_and_arrows." + instanceTier.toString().toLowerCase() + "_bow_damage")));
        super.appendHoverText(itemStack, $$1, components, $$3);
    }

    public void playerAttacksEntity(Player player, LivingEntity livingEntity) {
        switch (this.tier) {
            case BLAZE_ROD: {
                livingEntity.setRemainingFireTicks(40);
                break;
            }
            case BONE: {
                livingEntity.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 1));
                break;
            }
            case LIGHTNING_ROD: {
                CommonEffectsUtil.lightingCausedByPlayer(player, livingEntity.blockPosition());
                break;
            }
            case PAPER: {
                PaperEffectsUtil.randomEntityEffects(player, livingEntity);
            }
        }
    }

    public void playerAttacksBlock(Player player, BlockHitResult blockHitResult) {
        switch (this.tier) {
            case BLAZE_ROD: {
                CommonEffectsUtil.lightOrIgniteBlock(blockHitResult, player.level());
                break;
            }
            case LIGHTNING_ROD: {
                CommonEffectsUtil.lightingCausedByPlayer(player, blockHitResult.getBlockPos());
                break;
            }
            case PAPER: {
                PaperEffectsUtil.randomBlockEffects(player, blockHitResult);
            }
        }
    }
}

